/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set.wood;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.selene.block_set.BlockTypeRegistry;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.resourcepack.AfterLanguageLoadEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WoodTypeRegistry
extends BlockTypeRegistry<WoodType> {
    public static WoodTypeRegistry INSTANCE;
    public static Map<ResourceLocation, WoodType> WOOD_TYPES;

    public WoodTypeRegistry() {
        super(WoodType.class);
        INSTANCE = this;
    }

    public static WoodType fromNBT(String name) {
        return WOOD_TYPES.getOrDefault(new ResourceLocation(name), WoodType.OAK_WOOD_TYPE);
    }

    @Override
    public String typeName() {
        return "wood_type";
    }

    @Override
    public WoodType getDefaultType() {
        return WoodType.OAK_WOOD_TYPE;
    }

    @Override
    public Map<ResourceLocation, WoodType> getTypes() {
        if (!this.frozen) {
            throw new UnsupportedOperationException("Tried to access wood types too early");
        }
        return WOOD_TYPES;
    }

    @Override
    protected void saveTypes(ImmutableMap<ResourceLocation, WoodType> types) {
        WOOD_TYPES = types;
    }

    @Override
    public Optional<WoodType> detectTypeFromBlock(Block baseBlock) {
        Material mat;
        BlockState state;
        ResourceLocation baseRes = baseBlock.getRegistryName();
        String name = null;
        String path = baseRes.m_135815_();
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        if (!(name == null || baseRes.m_135827_().equals("securitycraft") || (state = baseBlock.m_49966_()).m_61147_().size() > 2 || baseBlock instanceof SlabBlock || (mat = state.m_60767_()) != Material.f_76320_ && mat != Material.f_76321_)) {
            name = name.replace("/", "_");
            ResourceLocation id = new ResourceLocation(baseRes.m_135827_(), name);
            Block logBlock = WoodTypeRegistry.findLog(id);
            if (logBlock != null) {
                return Optional.of(new WoodType(id, baseBlock, logBlock));
            }
        }
        return Optional.empty();
    }

    @Nullable
    private static Block findLog(ResourceLocation id) {
        ResourceLocation[] test = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_() + "_log"), new ResourceLocation(id.m_135827_(), "log_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_log"), new ResourceLocation("log_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_stem"), new ResourceLocation(id.m_135827_(), "stem_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_stem"), new ResourceLocation("stem_" + id.m_135815_())};
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!ForgeRegistries.BLOCKS.containsKey(r)) continue;
            temp = (Block)ForgeRegistries.BLOCKS.getValue(r);
            break;
        }
        return temp;
    }

    @Override
    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        WOOD_TYPES.forEach((r, w) -> {
            if (language.isDefault()) {
                language.addEntry(w.getTranslationKey(), w.getReadableName());
            }
        });
    }

    static {
        WOOD_TYPES = new LinkedHashMap<ResourceLocation, WoodType>();
    }
}

